/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xselftst.h 
 *       Selftest for exerciser/analyzer memories
 * -----------------------------------------------------------------*/
 
#ifndef __xselftst_H__
#define __xselftst_H__

#include <xtypedef.h> /* typedef.h includes xberror.h (defines bx_errtype). xtypedef defines bx_handletype and bx_charptrtype*/
#include <xselfdef.h>
#include <xpciapi.h>

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
  Test **************************************************************
 *******************************************************************/

CLI typedef enum {
  BX_SELFTST_RIBLK=0,     /* @riblk */
  BX_SELFTST_RIBEH=1,     /* @ribeh */
  BX_SELFTST_CTBEH=2,     /* @ctbeh */
  BX_SELFTST_CIBEH=3,     /* @cibeh */
  BX_SELFTST_RTBEH=4,     /* @rtbeh */
  BX_SELFTST_DATA=5,      /* @data */
  BX_SELFTST_TRACE=6,     /* @trace */
  BX_SELFTST_ALL=7,       /* @all */
  BX_SELFTST_ENUMSIZE     /* $enumsize */
} bx_selftsttype;
 
CLI bx_errtype EXPORT BestXSelfTest ( /* @selftest */
  bx_handletype    handle,
  bx_charptrtype  file,        /* $"c:\\bx_selftest.txt" */
  bx_int32        rows,        /* $5 */
  bx_int32        start,       /* $0 */
  bx_selftsttype  dev          /* $7 */
);



#ifdef __cplusplus
}
#endif




/* ----- Do not add code below this line ----- */
#endif /* defined __xselftst_H__ */
